//******************************************
//		: ADת
// 			:
//ӷʽ	:
//			:
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6811.h"
#include "ADC.h"



//-- header guards --//
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif


//-- Define IO port --//
#define	look_SDA		P9DR.bit.b0
#define	look_SCL		P9DR.bit.b1



//-- function definition --//
void delay_times(uchar tBase, uint x);
void look_data(uchar data);


//-- ȫֳ --//
const uchar t_1ms   = 0;
const uchar t_100us = 1;
const uchar t_6u    = 2;	//HIRC: 8MHz, CGCR/4
const uchar t_3u    = 3;	//HIRC:16MHz, CGCR/4


uint  ADC_Code_READ;
ulong ADC_VOLTAGE;
uchar data2Port[2];

uint  vref_l, vref_h;
ulong iReal_Vref2V, adc_value, adc_GND;
ulong VrefReal2048;


void main()
{
	uchar iloop;

//delay_times(t_1ms,100);
	WDCDR.byte = 0x4e;			// clear wdt
//	P90/P91(SDA/SCL) output for ADC result by IO_i2c
	P9DR.bit.b0 = 1;
	P9CR.bit.b0 = 1;
	P9DR.bit.b1 = 1;
	P9CR.bit.b1 = 1;
//	P80/P81 output monitor	// ۲ִʱ䣬ɾ
	P8DR.bit.b0 = 0;
	P8CR.bit.b0 = 1;
	P8DR.bit.b1 = 0;
	P8CR.bit.b1 = 1;


//-----------------------------------
//	perform this procedure once to get the actual value of internal Vref 2V
//	MQ6801:get the value of internal ADC reference voltage (unit: mV)
	iReal_Vref2V = GetVref();
//	do 16 conversion times
//	for( iloop=0; iloop<=(16/ad_test_times); iloop++ )
//		ADC_detect(Vref2, AIN_GND, Conv256CLK, ADC_Single);
//-----------------------------------
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt


//>>>>>>AD conversion times: ADC_ConvCode = ADC_ConvVolt(ͬ)
//......................................................................................................
//------ADC_ConvVolt(,,,):AD conversion result (unit: mV)
//		ADC_VOLTAGE   = ADC_ConvVolt(Vref2, AIN7, Conv128CLK, ADC_Single);
//......................................................................................................
//------ADC_ConvCode(,,,):AD conversion result code
		ADC_Code_READ = ADC_ConvCode(Vref2, AIN6, Conv128CLK, ADC_Single);
		//.........................|......|.....|...........| ADC_Single, ADC_Repeat
		//.........................|......|.....| Conv32CLK, Conv64CLK, Conv128CLK, Conv256CLK, Conv512CLK, Conv1024CLK
		//.........................|......|.....| (*conversion times must be between 12.8 us to 128 us)
		//.........................|......|.....| fcgck=16M... Conv256CLK(16us) ~ Conv1024CLK( 64us)
		//.........................|......|.....| fcgck= 8M... Conv128CLK(16us) ~ Conv1024CLK(128us)
		//.........................|......|.....| fcgck= 4M... Conv64CLK (16us) ~ Conv512CLK (128us)
		//.........................|......|.....| fcgck= 2M... Conv32CLK (16us) ~ Conv256CLK (128us)
		//.........................|......| AIN0~AIN8, VDD4_1, AIN_GND
		//.........................| Vref2, Vref3, Vref4, VDDVref, EXTVref
		// the following list is AD conversion time reference value, FCGCK= 8MHz,Conv128CLK(16us),Vref=2V
		// ad_test_times--Single(code)--Single(voltage)--Repeat(code)--Repeat(voltage)
		//       1      --  269us     --  269us        --  240us     --  240us
		//       2      --  380us     --  380us        --  295us     --  295us
		//       4      --  630us     --  630us        --  390us     --  390us
		//       8      -- 1120us     -- 1120us        --  580us     --  580us
		//      16      -- 2100us     -- 2100us        --  970us     --  970us

		data2Port[0] = ((ADC_Code_READ/100)%100);
		data2Port[1] = ((ADC_Code_READ/  1)%100);
	//	look_data(99); look_data(data2Port[0]); look_data(data2Port[1]);
		look_data(data2Port[0]); look_data(data2Port[1]);
//		ADC_VOLTAGE  = ((ulong)ADC_Code_READ * 2000) / 1024;	// only for setting ADC reference voltage to internal 2V
//		data2Port[0] = ((ADC_VOLTAGE/100)%100);
//		data2Port[1] = ((ADC_VOLTAGE/  1)%100);
//		look_data(data2Port[0]); look_data(data2Port[1]);

//		data2Port[0] = ((iReal_Vref2V/100)%100);
//		data2Port[1] = ((iReal_Vref2V/  1)%100);
//		look_data(88); look_data(data2Port[0]); look_data(data2Port[1]);
//		data2Port[0] = ((adc_GND/100)%100);
//		data2Port[1] = ((adc_GND/  1)%100);
//		look_data(0); look_data(data2Port[0]); look_data(data2Port[1]);
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}




//*********************************************************************
// name			: delay_times(uchar tBase, uint x)
// brief		: time delay function
// note			: ==> t_1ms   = 0;
// 			: ==> t_100us = 1;
// 			: ==> t_6u    = 2;	//HIRC: 8MHz, CGCR/4
// 			: ==> t_3u    = 3;	//HIRC:16MHz, CGCR/4
// 			: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;
	uchar cgcrF[4]={ 2, 4,  8, 1 };		// HIRC =>  8MHz
//	uchar cgcrF[4]={ 4, 8, 16, 2 };		// HIRC => 16MHz

	cgcrT = cgcrF[CGCR.byte];			// 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
	switch(tBase){
		case 0:		// t_1ms
			cgcrT *= 110;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 1:		// t_100us
			cgcrT *= 11;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 2:		// t_6u				// HIRC: 8MHz, CGCR/4
			for(; x>0; x--){}
			break;
		case 3:		// t_3u				// HIRC:16MHz, CGCR/4
			for(; x>0; x--){}
			break;
	}
	WDCDR.byte=0x4e; 			// clear wdt
}


//*********************************************************************
// name			: look_data()
// brief		: IO output data by IO_i2c
// note			:
//	//-- Define IO port --//
//	#define	look_SDA				P9DR.bit.b0
//	#define	look_SCL				P9DR.bit.b1
//*********************************************************************
void look_data(uchar data)
{
	uchar iloop, x, z=10;

//	start condition......
	look_SDA = 1;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	sent byte data......
	for( iloop=0; iloop<8; iloop++ )
	{
		look_SDA = data >> 7;
		data     = data << 1;
						for(x=z; x>0; x--){}
		look_SCL = 1;	for(x=z; x>0; x--){}
		look_SCL = 0;	for(x=z; x>0; x--){}
	}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	stop condition......
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 1;		for(x=z; x>0; x--){}
}



